/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.s9api.streams.XdmCollectors;
import net.sf.saxon.testdriver.Environment;
import net.sf.saxon.testdriver.Spec;
import net.sf.saxon.testdriver.TestDriverShell;
import net.sf.saxon.testdriver.TestReport;
import net.sf.saxon.trace.Instrumentation;
import net.sf.saxon.trans.UncheckedXPathException;
import org.w3c.dom.Document;

public abstract class TestDriver {
    protected String catalogFileName;
    private XdmNode catalogNode;
    protected String exceptionsFileName = "exceptions.xml";
    protected String reportFileName = null;
    protected String resultsDir = null;
    protected TestReport resultsDoc;
    protected int successes = 0;
    protected int failures = 0;
    protected int notrun = 0;
    protected int wrongErrorResults = 0;
    protected TestDriverShell shell = new TestDriverShell();
    protected boolean unfolded = false;
    protected boolean saveResults = false;
    protected boolean runPostureAndSweepTests = true;
    protected String optimizerFlags = "-";
    protected boolean jitFlag = false;
    protected int streaming = 1;
    protected TreeModel treeModel = TreeModel.TINY_TREE;
    protected boolean debug = false;
    protected boolean export = false;
    protected boolean runWithJS = false;
    protected boolean relocatable = false;
    protected String[] jsPlatforms = null;
    protected Pattern testPattern = null;
    protected String requestedTestSet = null;
    protected String testSuiteDir;
    protected Processor driverProc = null;
    protected Serializer driverSerializer = null;
    protected HashMap<String, XdmNode> exceptionsMap = new HashMap();
    protected HashMap<String, String> optimizationAssertions = new HashMap();
    protected Map<String, Environment> globalEnvironments = new HashMap<String, Environment>();
    protected Map<String, Environment> localEnvironments = new HashMap<String, Environment>();
    protected Map<String, File> queryModules = new HashMap<String, File>();
    protected Spec spec;
    protected String lang;
    protected boolean useXslt30Transformer = true;
    protected boolean tracing = false;
    protected boolean isAltova = false;
    protected Map<String, Integer> failSummary = new TreeMap<String, Integer>();
    protected boolean quiet = false;
    protected boolean strict = false;
    protected Set<String> laxTests = new HashSet<String>();
    static Set<String> unsharedEnvironments = new HashSet<String>();

    public abstract String catalogNamespace();

    public boolean hasEECapability() {
        return false;
    }

    public void go(String[] args) throws Exception {
        long startTime = System.nanoTime();
        if (this.driverProc == null) {
            this.driverProc = new Processor(false);
        }
        this.driverSerializer = this.driverProc.newSerializer();
        System.err.println("Testing " + this.getProductEdition() + " " + Version.getProductVersion());
        System.err.println("Java version " + System.getProperty("java.version"));
        this.testSuiteDir = args[0];
        String catalog = args[1];
        char separatorChar = '/';
        if (File.separatorChar != '/') {
            separatorChar = '\\';
        }
        if (!this.testSuiteDir.endsWith("" + separatorChar)) {
            this.testSuiteDir = this.testSuiteDir + separatorChar;
        }
        this.catalogFileName = catalog;
        catalog = this.testSuiteDir + catalog;
        for (int i = 2; i < args.length; ++i) {
            String argValue;
            int colon = args[i].indexOf(58);
            String string = argValue = colon < 0 ? "" : args[i].substring(colon + 1);
            if (args[i].startsWith("-t:")) {
                this.testPattern = Pattern.compile(argValue);
            }
            if (args[i].startsWith("-s:")) {
                this.requestedTestSet = argValue;
            }
            if (args[i].equals("-quiet")) {
                this.quiet = true;
            }
            if (args[i].startsWith("-o:")) {
                this.resultsDir = argValue;
            }
            if (args[i].startsWith("-debug")) {
                this.debug = true;
            }
            if (args[i].startsWith("-strict")) {
                this.strict = true;
            }
            if (args[i].startsWith("-export") && !argValue.equals("off")) {
                this.export = true;
            }
            if (args[i].startsWith("-jit") && !argValue.equals("off")) {
                this.jitFlag = true;
            }
            if (args[i].startsWith("-js")) {
                this.export = true;
                this.runWithJS = true;
                this.treeModel = DOMObjectModel.getInstance();
                this.jsPlatforms = new String[]{"browser", "nodejs"};
            }
            if (args[i].equals("-unfolded")) {
                this.unfolded = true;
            }
            if (args[i].equals("-save")) {
                this.saveResults = true;
            }
            if (args[i].startsWith("-exceptions:")) {
                this.exceptionsFileName = argValue;
            }
            if (args[i].startsWith("-reportfilename:")) {
                this.reportFileName = argValue;
            }
            if (args[i].equals("-T")) {
                this.tracing = true;
            }
            if (args[i].startsWith("-bytecode:")) {
                System.err.println("***WARNING*** -bytecode option is ignored");
            }
            if (args[i].startsWith("-streaming:")) {
                switch (argValue) {
                    case "off": {
                        this.streaming = 0;
                        break;
                    }
                    case "on": {
                        this.streaming = 1;
                        break;
                    }
                    case "strict": {
                        this.streaming = 3;
                        break;
                    }
                    default: {
                        throw new Exception("-streaming must be off|on|strict");
                    }
                }
            }
            if (args[i].startsWith("-tree")) {
                this.treeModel = this.getTreeModel(argValue);
                if (this.treeModel == null) {
                    throw new Exception("The requested TreeModel '" + argValue + "' does not exist");
                }
            }
            if (args[i].startsWith("-lang:")) {
                this.lang = argValue;
                this.processSpec(argValue);
            }
            if (args[i].startsWith("-xt30:")) {
                this.useXslt30Transformer = argValue.equals("on");
            }
            if (args[i].startsWith("-ps:")) {
                this.runPostureAndSweepTests = argValue.equals("on");
            }
            if (args[i].startsWith("-relocatable:")) {
                this.relocatable = argValue.equals("on");
            }
            if (!args[i].startsWith("-opt:")) continue;
            this.optimizerFlags = argValue;
        }
        if (this.resultsDoc == null) {
            this.printError("No result document: missing -lang option", "");
            if (this.shell == null) {
                System.exit(2);
            }
        }
        if (this.resultsDir == null) {
            this.printError("No results directory specified (use -o:dirname)", "");
            if (this.shell == null) {
                System.exit(2);
            }
        }
        System.err.println("UsingXslt30Transformer: " + this.useXslt30Transformer);
        System.err.println("Relocatable: " + this.relocatable);
        this.driverSerializer.setOutputStream((OutputStream)System.err);
        this.driverSerializer.setOutputProperty(Serializer.Property.METHOD, "adaptive");
        this.driverSerializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        this.driverSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        this.driverProc.setConfigurationProperty(Feature.STABLE_UNPARSED_TEXT, (Object)true);
        this.processCatalog(new File(catalog));
        System.err.println("Finished in " + (System.nanoTime() - startTime) / 1000000000L + "s");
        this.printResults(this.resultsDir + "/results" + Version.getProductVersion() + ".xml");
        Instrumentation.report();
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        System.err.println("Wrapping up. Looking for dangling threads.");
        this.driverProc.getUnderlyingConfiguration().close();
        System.gc();
        Thread mainThread = null;
        for (Thread t : threadSet) {
            if (t.getThreadGroup() != null && "system".equals(t.getThreadGroup().getName())) {
                System.err.println("System thread: " + t);
                continue;
            }
            if ("main".equals(t.getName())) {
                if (mainThread == null) {
                    System.err.println("Main thread: " + t);
                    mainThread = t;
                    continue;
                }
                System.err.println("UNEXPECTED main thread: " + t);
                continue;
            }
            if ("Common-Cleaner".equals(t.getName())) {
                System.err.println("Common Cleaner thread: " + t);
                continue;
            }
            if ("Cleaner".equals(t.getName())) {
                System.err.println("Cleaner thread: " + t);
                continue;
            }
            System.err.println("Unexpected thread: " + t);
        }
        System.exit(0);
    }

    protected TreeModel getTreeModel(String s) {
        DOMObjectModel tree = null;
        if (s.equalsIgnoreCase("dom")) {
            tree = new DOMObjectModel();
        } else if (s.equalsIgnoreCase("tinytree")) {
            tree = TreeModel.TINY_TREE;
        } else if (s.equalsIgnoreCase("condensed")) {
            tree = TreeModel.TINY_TREE_CONDENSED;
        } else if (s.equalsIgnoreCase("linked")) {
            tree = TreeModel.LINKED_TREE;
        }
        return tree;
    }

    public XdmNode makeDominoTree(Document doc, Configuration config, String baseUri) throws SaxonApiException {
        throw new UnsupportedOperationException("Domino needs PE+");
    }

    public String getResultsDir() {
        return this.resultsDir;
    }

    public abstract void processSpec(String var1);

    public String getProductEdition() {
        return "Saxon-" + this.driverProc.getSaxonEdition();
    }

    public String getProductVersion() {
        return Version.getProductVersion();
    }

    public void prepareForSQL(Processor processor) {
    }

    protected void processCatalog(File catalogFile) throws SaxonApiException {
        XdmNode catalog;
        DocumentBuilder catbuilder = this.driverProc.newDocumentBuilder();
        catbuilder.setTreeModel(this.treeModel);
        catbuilder.setLineNumbering(true);
        this.catalogNode = catalog = catbuilder.build(catalogFile);
        XPathCompiler xpc = this.driverProc.newXPathCompiler();
        xpc.setLanguageVersion("3.1");
        xpc.setCaching(true);
        xpc.declareNamespace("", this.catalogNamespace());
        if (this.requestedTestSet == null) {
            this.createGlobalEnvironments(catalog, xpc);
        }
        try {
            this.writeResultFilePreamble(this.driverProc, catalog);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.readExceptionsFile();
        if (this.requestedTestSet != null) {
            try {
                Predicate<XdmNode> isRequestedTestSet = node -> this.requestedTestSet.equals(node.attribute("name"));
                Optional funcSetNode = catalog.select(Steps.descendant((String)"test-set").where(isRequestedTestSet)).asOptionalNode();
                if (!funcSetNode.isPresent()) {
                    throw new Exception("Test-set " + this.requestedTestSet + " not found!");
                }
                this.processTestSet(catbuilder, xpc, (XdmNode)funcSetNode.get());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            for (XdmNode testSet : catalog.select(Steps.descendant((String)"test-set")).asList()) {
                this.processTestSet(catbuilder, xpc, testSet);
            }
        }
        try {
            this.writeResultFilePostamble();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getNameOfExceptionsFile() {
        return this.exceptionsFileName;
    }

    protected void readExceptionsFile() {
        XdmNode exceptionsDoc = null;
        DocumentBuilder exceptBuilder = this.driverProc.newDocumentBuilder();
        QName testSet = new QName("test-set");
        QName testCase = new QName("test-case");
        QName run = new QName("run");
        QName edition = new QName("edition");
        QName platform = new QName("platform");
        QName compiler = new QName("compiler");
        QName relocate = new QName("relocatable");
        String saxonEdition = this.driverProc.getSaxonEdition();
        try {
            String suppliedName = this.getNameOfExceptionsFile();
            File exceptionsFile = suppliedName.startsWith("/") || suppliedName.matches("^[a-zA-Z]:.*") ? new File(suppliedName) : new File(this.resultsDir + "/" + suppliedName);
            System.err.println("Loading exceptions file " + exceptionsFile.getAbsolutePath());
            exceptionsDoc = exceptBuilder.build(exceptionsFile);
            XdmSequenceIterator iter = exceptionsDoc.axisIterator(Axis.DESCENDANT, new QName("exception"));
            while (iter.hasNext()) {
                String[] platformVal;
                int n;
                XdmNode entry = (XdmNode)iter.next();
                String testName = entry.getAttributeValue(testCase);
                if (testName == null) {
                    testName = "$" + entry.getAttributeValue(testSet);
                }
                String runVal = entry.getAttributeValue(run);
                String editionVal = entry.getAttributeValue(edition);
                if (runVal == null) {
                    runVal = "false";
                }
                if (editionVal == null) {
                    editionVal = saxonEdition;
                }
                boolean appliesThisEdition = false;
                String[] stringArray = editionVal.trim().split("\\s+");
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String ed = stringArray[n];
                    if (!ed.equals(saxonEdition)) continue;
                    appliesThisEdition = true;
                    break;
                }
                if ("no".equals(entry.attribute("strict"))) {
                    this.laxTests.add(testName);
                }
                if (this.runWithJS) {
                    String relocateVal;
                    String compilerVal;
                    platformVal = entry.getAttributeValue(platform);
                    if (platformVal == null) {
                        platformVal = "";
                    }
                    if ((compilerVal = entry.getAttributeValue(compiler)) == null) {
                        compilerVal = "";
                    }
                    if ((relocateVal = entry.getAttributeValue(relocate)) == null) {
                        relocateVal = "";
                    }
                    relocateVal = relocateVal.trim();
                    if (!compilerVal.equals("")) {
                        String[] exceptedCompilers = compilerVal.trim().split("\\s+");
                        boolean exceptionCoversThisCompiler = false;
                        String[] stringArray2 = exceptedCompilers;
                        int n3 = stringArray2.length;
                        for (int i = 0; i < n3; ++i) {
                            String c = stringArray2[i];
                            if (!c.equals("XJ")) continue;
                            exceptionCoversThisCompiler = true;
                            break;
                        }
                        if (!exceptionCoversThisCompiler) {
                            appliesThisEdition = false;
                        }
                    }
                    if (!platformVal.equals("")) {
                        String[] exceptedPlatforms = platformVal.trim().split("\\s+");
                        for (String plt : this.jsPlatforms) {
                            boolean exceptionCoversThisPlatform = false;
                            for (String p : exceptedPlatforms) {
                                if (!p.equals(plt)) continue;
                                exceptionCoversThisPlatform = true;
                                break;
                            }
                            if (exceptionCoversThisPlatform) continue;
                            appliesThisEdition = false;
                            break;
                        }
                    }
                    if (relocateVal.equals("on") && !this.relocatable || relocateVal.equals("off") && this.relocatable) {
                        appliesThisEdition = false;
                    }
                }
                if (!appliesThisEdition) continue;
                if (runVal.equals("false")) {
                    platformVal = testName.trim().split("\\s+");
                    int compilerVal = platformVal.length;
                    for (n = 0; n < compilerVal; ++n) {
                        String tc = platformVal[n];
                        this.exceptionsMap.put(tc, entry);
                    }
                    continue;
                }
                XdmSequenceIterator iter2 = entry.axisIterator(Axis.CHILD, new QName("optimization"));
                if (!iter2.hasNext()) continue;
                XdmNode optim = (XdmNode)iter2.next();
                this.optimizationAssertions.put(testName, optim.attribute("assert"));
            }
        }
        catch (SaxonApiException e) {
            this.printError("*** Failed to process exceptions file: ", e.getMessage());
        }
    }

    protected abstract void createGlobalEnvironments(XdmNode var1, XPathCompiler var2) throws SaxonApiException;

    protected void createLocalEnvironments(XdmNode testSetDocNode) {
        this.localEnvironments.clear();
        Environment defaultEnvironment = Environment.createLocalEnvironment(testSetDocNode.getBaseURI(), this.unfolded, this.spec, this);
        this.localEnvironments.put("default", defaultEnvironment);
    }

    protected Environment getEnvironment(XdmNode testCase, XPathCompiler xpc) throws SaxonApiException {
        Environment env;
        String testCaseName = testCase.attribute("name");
        Optional environmentNode = testCase.select(Steps.child((String)"environment")).asOptionalNode();
        if (!environmentNode.isPresent()) {
            env = this.localEnvironments.get("default");
        } else {
            String envName = ((XdmNode)environmentNode.get()).attribute("ref");
            if (envName == null || envName.equals("")) {
                boolean baseUriCheck;
                block15: {
                    baseUriCheck = false;
                    env = null;
                    try {
                        env = Environment.processEnvironment(this, xpc, (XdmNode)environmentNode.get(), null, this.localEnvironments.get("default"));
                        baseUriCheck = ((XdmNode)environmentNode.get()).select(Steps.child((String)"static-base-uri").where(Predicates.attributeEq((String)"uri", (String)"#UNDEFINED"))).exists();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                        System.err.println("Failure loading environment");
                        if (env == null) break block15;
                        env.usable = false;
                    }
                }
                if (baseUriCheck) {
                    return null;
                }
            } else {
                block16: {
                    env = this.localEnvironments.get(envName);
                    if (env == null) {
                        env = this.globalEnvironments.get(envName);
                    }
                    if (env == null) {
                        try {
                            for (XdmNode e : testCase.getParent().select(Steps.descendant((String)"environment").where(Predicates.attributeEq((String)"name", (String)envName))).asList()) {
                                Environment.processEnvironment(this, xpc, e, this.localEnvironments, this.localEnvironments.get("default"));
                            }
                            env = this.localEnvironments.get(envName);
                            if (unsharedEnvironments.contains(envName)) {
                                this.localEnvironments.remove(envName);
                            }
                        }
                        catch (NullPointerException ex) {
                            ex.printStackTrace();
                            System.err.println("Failure loading environment");
                            if (env == null) break block16;
                            env.usable = false;
                        }
                    }
                }
                if (env == null) {
                    this.createGlobalEnvironments(this.catalogNode, xpc);
                    env = this.globalEnvironments.get(envName);
                }
                if (env == null) {
                    this.println("*** Unknown environment " + envName);
                    this.noteFailure(testCase.getParent().attribute("name"), testCaseName);
                    return null;
                }
            }
        }
        return env;
    }

    public void registerXQueryModule(String uri, File resource) {
        this.queryModules.put(uri, resource);
    }

    public File exportStylesheet(XsltCompiler compiler, String fileName) throws SaxonApiException {
        return null;
    }

    public void addInjection(XQueryCompiler compiler) {
    }

    public void noteFailure(String testSet, String testCase) {
        ++this.failures;
        if (this.requestedTestSet != null) {
            this.failSummary.put(testCase, 1);
        } else {
            this.failSummary.merge(testSet, 1, (a, b) -> a + b);
        }
    }

    protected void writeResultFilePreamble(Processor processor, XdmNode catalog) throws IOException, SaxonApiException, XMLStreamException {
        this.resultsDoc.writeResultFilePreamble(processor, catalog);
    }

    protected void writeResultFilePostamble() throws XMLStreamException {
        this.resultsDoc.writeResultFilePostamble();
        if (this.requestedTestSet != null) {
            System.err.println("Failing tests: ");
            for (Map.Entry<String, Integer> entry : this.failSummary.entrySet()) {
                System.err.println("  " + entry.getKey());
            }
        } else {
            System.err.println("Failures by Test Set: ");
            for (Map.Entry<String, Integer> entry : this.failSummary.entrySet()) {
                System.err.println("  " + entry.getKey() + " : " + entry.getValue());
            }
        }
    }

    protected void startTestSetElement(XdmNode testSetNode) {
        this.resultsDoc.startTestSetElement(testSetNode);
    }

    protected void writeTestSetEndElement() {
        this.resultsDoc.endElement();
    }

    private void processTestSet(DocumentBuilder catbuilder, XPathCompiler xpc, XdmNode testSetNode) throws SaxonApiException {
        this.startTestSetElement(testSetNode);
        File testSetFile = new File(this.testSuiteDir + "/" + testSetNode.attribute("file"));
        XdmNode testSetDocNode = catbuilder.build(testSetFile);
        this.createLocalEnvironments(testSetDocNode);
        boolean run = true;
        if (testSetDocNode.select(Steps.child((String)"test-set").then(Steps.child((String)"dependency"))).exists()) {
            for (XdmNode dependency : testSetDocNode.select(Steps.child((String)"test-set").then(Steps.child((String)"dependency"))).asList()) {
                if (this.ensureDependencySatisfied(dependency, this.localEnvironments.get("default"))) continue;
                for (XdmNode testCase2 : testSetDocNode.select(Steps.descendant((String)"test-case")).asList()) {
                    String testCaseName = testCase2.attribute("name");
                    this.resultsDoc.writeTestcaseElement(testCaseName, "n/a", "test-set dependencies not satisfied");
                    ++this.notrun;
                }
                run = false;
                break;
            }
        }
        if (testSetDocNode.select(Steps.child((String)"test-set").then(Steps.child((String)"dependencies"))).exists()) {
            for (XdmNode dependency : testSetDocNode.select(Steps.path((String[])new String[]{"test-set", "dependencies", "*"})).asListOfNodes()) {
                if (this.ensureDependencySatisfied(dependency, this.localEnvironments.get("default"))) continue;
                for (XdmNode testCase2 : testSetDocNode.select(Steps.descendant((String)"test-case")).asList()) {
                    String type = dependency.getNodeName().getLocalName();
                    String value = dependency.attribute("value");
                    value = value == null ? type : type + ":" + value;
                    if ("false".equals(dependency.attribute("satisfied"))) {
                        value = "!" + value;
                    }
                    String testCaseName = testCase2.attribute("name");
                    this.resultsDoc.writeTestcaseElement(testCaseName, "n/a", "test-set dependencies not satisfied: " + value);
                    ++this.notrun;
                }
                run = false;
                break;
            }
        }
        if (run) {
            if (this.testPattern == null) {
                for (XdmNode env : testSetDocNode.select(Steps.descendant((String)"environment").where(Predicates.hasAttribute((String)"name"))).asList()) {
                    String envName = env.attribute("name");
                    if (unsharedEnvironments.contains(envName)) continue;
                    try {
                        Environment.processEnvironment(this, xpc, env, this.localEnvironments, this.localEnvironments.get("default"));
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                        System.err.println("Failure loading environment, in processTestSet");
                    }
                }
            }
            String testSet = (String)testSetDocNode.select(Steps.path((String[])new String[]{"/", "test-set", "@name"})).collect((Collector)XdmCollectors.asString());
            testSetDocNode.select(Steps.descendant((String)"test-case")).forEach(testCase -> {
                String name = testCase.attribute("name");
                if (this.testPattern == null || this.testPattern.matcher(name).matches()) {
                    this.println("-s:" + testSet + " -t:" + name);
                    try {
                        this.runTestCase((XdmNode)testCase, xpc);
                    }
                    catch (SaxonApiException | SaxonApiUncheckedException | UncheckedXPathException ex) {
                        ex.printStackTrace();
                        System.err.println("*** Error in evaluating testcase:" + ex.getMessage());
                    }
                }
            });
        }
        this.writeTestSetEndElement();
    }

    protected abstract void runTestCase(XdmNode var1, XPathCompiler var2) throws SaxonApiException;

    public void setTestDriverShell(TestDriverShell gui) {
        this.shell = gui;
    }

    public void println(String data) {
        if (!this.quiet) {
            this.shell.println(data);
        }
    }

    public void printResults(String resultsFileStr) {
        this.shell.printResults("Result: " + this.successes + " successes, " + this.failures + " failures, " + this.wrongErrorResults + " incorrect ErrorCode, " + this.notrun + " not run", resultsFileStr, this.resultsDir);
    }

    public void printError(String error, String message) {
        this.shell.alert(error);
        this.shell.println(error + message);
    }

    public void printError(String error, Exception e) {
        this.shell.alert(error);
        e.printStackTrace();
    }

    public abstract boolean ensureDependencySatisfied(XdmNode var1, Environment var2);

    protected void copySchemaNamespaces(Environment env, XPathCompiler testXpc) {
        Configuration config = env.xpathCompiler.getProcessor().getUnderlyingConfiguration();
        for (NamespaceUri s : config.getImportedNamespaces()) {
            testXpc.importSchemaNamespace(s.toString());
        }
    }

    static {
        unsharedEnvironments.add("import-schema-e01");
        unsharedEnvironments.add("merge002");
    }
}

