/**
 * <p>This package contains an implementation of the XQJ specification
 * defined in JSR 225. This API never became part of the Java Standard Edition platform, but it
 * is supported by a variety of Java-based XQuery engines.</p>
 * <p>Saxon's implementation of the {@link javax.xml.xquery.XQDataSource} class is
 * {@link com.saxonica.xqj.SaxonXQDataSource}. Generally, this is the only class
 * that applications need to access directly (all other access can be done by using
 * standard XQJ interfaces). However, if there is a need to mix XQuery access with other
 * Saxon functionality such as schema processing, then it is often useful to cast the
 * XQJ objects to their underlying Saxon implementation classes, which make additional
 * methods available.</p>
 * <p>In general it is not possible to mix Saxon implementation classes of the XQJ interface
 * with implementation classes from other vendors. That is, if an interface specifies that
 * a value of an XQJ type must be passed as an argument, Saxon in general requires the value
 * to belong to a Saxon implementation of that interface.</p>
 * <p>Although this implementation of XQJ is issued under the open source Mozilla Public License,
 * users should be aware of the terms and conditions included in the XQJ specification (JSR 225)
 * which may (under some interpretations) restrict the right to make modifications. In particular,
 * the terms and conditions published in JSR 225 require implementations to pass the
 * compatibility tests, and to contain no extensions. Because the
 * terms and conditions for the XQJ specification do not comply with some definitions of "open
 * source", the XQJ module is not included in the standard Saxon-HE jar files, but is issued
 * separately.</p>
 * <p>JSR 225 was published to work with XQuery 1.0, and as a result, it does not support the
 * richer type system of XQuery 3.1. For example, there are no mechanisms to supply maps and arrays
 * as input to a query, or to handle maps and arrays in the query result. It is possible to work
 * around some of these limitations by customizing the {@link com.saxonica.xqj.SaxonXQDataSource}
 * with a user-written {@link com.saxonica.xqj.ObjectConverter}, provided you are confident that
 * you are not thereby violating Oracle's licensing rules.</p>
 * <p>Despite the prohibitions on extending the JSR 225 interface, Saxonica's implementation of XQJ does allow
 * XQuery 3.1 syntax to be used within the queries submitted for execution.</p>
 */
package com.saxonica.xqj;

// Copyright (c) 2010-2023 Saxonica Limited.
