/*
 * Copyright # 2003, 2004, 2005, 2006, 2007, 2008 Oracle.  All rights reserved.
 */

package javax.xml.xquery;

/**
 * An object that registers to be notified of events generated by a
 * <code>PooledXQConnection</code> object.
 *
 * <p>The <code>XQConnectionEventListener</code> interface is implemented by a
 * connection pooling component.  A connection pooling component will
 * usually be provided by an XQJ vendor or by another system software
 * vendor.  An XQJ implementation notifies an <code>XQConnectionEventListener</code>
 * object when an application is finished using a pooled connection with
 * which the listener has registered.  The notification
 * occurs after the application calls the method <code>close</code> on
 * its representation of a <code>PooledXQConnection</code> object.  An
 * <code>XQConnectionEventListener</code> is also notified when a
 * connection error occurs due to the fact that the <code>PooledXQConnection</code>
 * is unfit for future use - the network connection to the XML datasource died, for example.
 * The listener is notified by the XQJ implementation just before it throws an
 * <code>XQException</code> to the application using the
 * <code>PooledXQConnection</code> object.</p>
 */

public interface XQConnectionEventListener {

    /**
     * Notifies this <code>XQConnectionEventListener</code> that
     * the application has called the method <code>close</code> on its
     * representation of a pooled connection.
     *
     * @param event an event object describing the source of
     *              the event
     */
    void connectionClosed(XQConnectionEvent event);

    /**
     * Notifies this <code>XQConnectionEventListener</code> that
     * a fatal error has occurred and the pooled connection can
     * no longer be used.  The XQJ implementation makes this notification just
     * before it throws the application the <code>XQException</code>
     * contained in the given <code>XQConnectionEvent</code> object.
     *
     * @param event an event object describing the source of
     *              the event and containing the <code>XQException</code> that the
     *              XQJ implementation will throw
     */
    void connectionErrorOccurred(XQConnectionEvent event);
}
