/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.SaxonXQItemType;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequenceType;
import net.sf.saxon.Configuration;
import net.sf.saxon.value.SequenceType;

public class SaxonXQSequenceType
implements XQSequenceType {
    SequenceType sequenceType;
    Configuration config;

    SaxonXQSequenceType(SequenceType sequenceType, Configuration config) {
        this.sequenceType = sequenceType;
        this.config = config;
    }

    @Override
    public int getItemOccurrence() {
        int cardinality = this.sequenceType.getCardinality();
        switch (cardinality) {
            case 16384: {
                return 2;
            }
            case 24576: {
                return 1;
            }
            case 49152: {
                return 4;
            }
            case 57344: {
                return 3;
            }
        }
        return 3;
    }

    @Override
    public XQItemType getItemType() {
        return new SaxonXQItemType(this.sequenceType.getPrimaryType(), this.config);
    }

    public String getString() {
        String s = this.sequenceType.getPrimaryType().toString();
        switch (this.sequenceType.getCardinality()) {
            case 16384: {
                return s;
            }
            case 24576: {
                return s + "?";
            }
            case 49152: {
                return s + "+";
            }
            case 57344: {
                return s + "*";
            }
        }
        return s;
    }

    @Override
    public String toString() {
        return this.getString();
    }
}

