/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import com.saxonica.xqj.pull.TreeWalker;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pull.PullEvent;
import net.sf.saxon.pull.UnfailingPullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public class PullFromIterator
implements UnfailingPullProvider {
    private final FocusIterator base;
    private UnfailingPullProvider treeWalker = null;
    private PipelineConfiguration pipe;
    private PullEvent currentEvent = PullEvent.START_OF_INPUT;

    public PullFromIterator(SequenceIterator base) {
        this.base = SequenceTool.focusTracker((SequenceIterator)base);
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public PullEvent next() throws XPathException {
        if (this.treeWalker == null) {
            Item item = this.base.next();
            if (item == null) {
                this.currentEvent = PullEvent.END_OF_INPUT;
                return this.currentEvent;
            }
            if (item instanceof AtomicValue) {
                this.currentEvent = PullEvent.ATOMIC_VALUE;
                return this.currentEvent;
            }
            switch (((NodeInfo)item).getNodeKind()) {
                case 3: {
                    this.currentEvent = PullEvent.TEXT;
                    return this.currentEvent;
                }
                case 8: {
                    this.currentEvent = PullEvent.COMMENT;
                    return this.currentEvent;
                }
                case 7: {
                    this.currentEvent = PullEvent.PROCESSING_INSTRUCTION;
                    return this.currentEvent;
                }
                case 2: {
                    this.currentEvent = PullEvent.ATTRIBUTE;
                    return this.currentEvent;
                }
                case 13: {
                    this.currentEvent = PullEvent.NAMESPACE;
                    return this.currentEvent;
                }
                case 1: 
                case 9: {
                    this.treeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                    this.treeWalker.setPipelineConfiguration(this.pipe);
                    this.currentEvent = this.treeWalker.next();
                    return this.currentEvent;
                }
            }
            throw new IllegalStateException();
        }
        PullEvent event = this.treeWalker.next();
        if (event == PullEvent.END_OF_INPUT) {
            this.treeWalker = null;
            this.currentEvent = this.next();
        } else {
            this.currentEvent = event;
        }
        return this.currentEvent;
    }

    public PullEvent current() {
        return this.currentEvent;
    }

    public AttributeMap getAttributes() {
        if (this.treeWalker != null) {
            return this.treeWalker.getAttributes();
        }
        throw new IllegalStateException();
    }

    public NamespaceBinding[] getNamespaceDeclarations() {
        if (this.treeWalker != null) {
            return this.treeWalker.getNamespaceDeclarations();
        }
        throw new IllegalStateException();
    }

    public PullEvent skipToMatchingEnd() {
        if (this.treeWalker != null) {
            return this.treeWalker.skipToMatchingEnd();
        }
        throw new IllegalStateException();
    }

    public void close() {
        if (this.treeWalker != null) {
            this.treeWalker.close();
        }
    }

    public NodeName getNodeName() {
        if (this.treeWalker != null) {
            return this.treeWalker.getNodeName();
        }
        Item item = this.base.current();
        if (item instanceof NodeInfo) {
            return NameOfNode.makeName((NodeInfo)((NodeInfo)item));
        }
        throw new IllegalStateException();
    }

    public UnicodeString getStringValue() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getStringValue();
        }
        Item item = this.base.current();
        return item.getUnicodeStringValue();
    }

    public AtomicValue getAtomicValue() {
        if (this.currentEvent == PullEvent.ATOMIC_VALUE) {
            return (AtomicValue)this.base.current();
        }
        throw new IllegalStateException();
    }

    public SchemaType getSchemaType() {
        if (this.treeWalker != null) {
            return this.treeWalker.getSchemaType();
        }
        Item item = this.base.current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSchemaType();
        }
        return ((AtomicValue)item).getItemType();
    }

    public Location getSourceLocator() {
        if (this.treeWalker != null) {
            return this.treeWalker.getSourceLocator();
        }
        return null;
    }

    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

