/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.OpRepeat;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSingletonIterator;

public class OpUnambiguousRepeat
extends OpRepeat {
    OpUnambiguousRepeat(Operation op, int min, int max) {
        super(op, min, max, true);
    }

    @Override
    public int matchesEmptyString() {
        if (this.min == 0) {
            return 7;
        }
        return this.op.matchesEmptyString();
    }

    @Override
    public int getMatchLength() {
        if (this.op.getMatchLength() != -1 && this.min == this.max) {
            return this.op.getMatchLength() * this.min;
        }
        return -1;
    }

    @Override
    public int getMaxLoopingDepth() {
        return this.op.getMaxLoopingDepth() + 1;
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        this.op = this.op.optimize(program, flags);
        return this;
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        IntIterator it;
        int matches;
        int guard = matcher.search.length32();
        int p = position;
        for (matches = 0; matches < this.max && p <= guard && (it = this.op.iterateMatches(matcher, p)).hasNext(); ++matches) {
            p = it.next();
        }
        if (matches < this.min) {
            return EmptyIntIterator.getInstance();
        }
        return new IntSingletonIterator(p);
    }
}

